/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.monitor.service.impl;

import com.tp_link.eap.domain.eap.LogInfo;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.monitor.repo.LogRepository;
import com.tp_link.eap.monitor.monitor.service.g;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.a.b;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.c.a;
import com.tp_link.eap.util.l;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="logService")
public class LogService
extends com.tp_link.eap.i.a.a<LogInfo>
implements g {
    private static final Logger a = LoggerFactory.getLogger(LogService.class);
    @Autowired
    private LogRepository b;
    @Autowired
    private MongoTemplate c;

    @Override
    public List<LogInfo> getLogs() {
        return com.tp_link.eap.util.a.a.a((Iterable)this.b.findAll());
    }

    @Override
    public boolean addLog(LogInfo log) {
        if (null == log) {
            return false;
        }
        log.setSite(com.tp_link.eap.d.b.a());
        this.b();
        this.b.save(log);
        return true;
    }

    @Override
    public boolean addLogs(List<LogInfo> logs) {
        if (logs == null || logs.isEmpty()) {
            return false;
        }
        this.b.save(logs);
        this.b();
        return true;
    }

    @Override
    public boolean refreshLogs(String apMac, List<LogInfo> logs) {
        if (logs == null || logs.isEmpty() || apMac == null) {
            return false;
        }
        this.addLogs(logs);
        return true;
    }

    public List<LogInfo> getList(QueryPage queryPage, QuerySort querySort) {
        return this.getList(queryPage, querySort, null, null);
    }

    public List<LogInfo> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.getList(queryPage, null, filters, searchFilters);
    }

    public List<LogInfo> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.b.getByFilters(queryPage, querySort, filters, searchFilters);
    }

    public List<LogInfo> getList(QueryPage queryPage) {
        return this.getList(queryPage, null, null, null);
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.b.countByFilters(filters, searchFilters);
    }

    private OperationResponse a(String string) {
        if (e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        try {
            this.b.delete((Serializable)((Object)string));
            return com.tp_link.eap.util.e.bd;
        }
        catch (Exception exception) {
            return com.tp_link.eap.util.e.bg;
        }
    }

    @Override
    public OperationResponse deleteLog(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("logId");
        if (e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.a(string);
    }

    private OperationResponse a() {
        try {
            List<LogInfo> list = this.b.findBySite(com.tp_link.eap.d.b.a());
            this.b.delete(list);
            return com.tp_link.eap.util.e.bd;
        }
        catch (Exception exception) {
            return com.tp_link.eap.util.e.bg;
        }
    }

    @Override
    public OperationResponse clearLogs(ControlType controlType, JSONObject reqObj) {
        return this.a();
    }

    @Override
    public OperationResult clearLogs(Date date) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"time").lt((Object)date));
        this.c.remove(query, LogInfo.class);
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public List<LogInfo> getLogsAfterDate(Date date) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"time").gt((Object)date));
        return this.c.find(query, LogInfo.class);
    }

    @Override
    public boolean deleteLogs(String apMac) {
        String string = com.tp_link.eap.d.b.a();
        List<LogInfo> list = this.b.findByApMacAndSite(apMac, string);
        if (!CollectionUtils.isEmpty(list)) {
            this.b.delete(list);
        }
        return true;
    }

    @Override
    public void deleteAllLogs() {
        this.b.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse getGridLogs(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)com.tp_link.eap.util.a.b.a((Object)jSONObject, QueryData.class);
        if (e.a((String)queryData.getSortName())) {
            queryData.setSortName("time");
            queryData.setSortOrder("desc");
        }
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[]{"apMac", "level", "logContent"});
        Integer n2 = 0;
        try {
            n2 = (Integer)queryData.getFilters().get("reserve");
        }
        catch (NumberFormatException numberFormatException) {
            a.debug("log filter, reserve days number format exception");
        }
        finally {
            if (n2 <= 0) {
                n2 = 90;
            }
        }
        grid.initFilters("time", (Object)new Date(), QueryFilter.FilterType.lte);
        grid.initFilters("time", (Object)com.tp_link.eap.util.c.a.c((int)n2), QueryFilter.FilterType.gte);
        long l2 = this.count(grid.getFilters(), grid.getSearchFilters());
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    private void b() {
        if (l.b()) {
            return;
        }
        long l2 = this.b.count();
        while (l2 != 0L && l2 >= 11000L) {
            a.info("log num {} has reached maximum", (Object)l2);
            this.b.clearTop(1000, "time");
            l2 = this.b.count();
            a.info("after clear, log num is {}", (Object)l2);
        }
    }
}

